; NOTE: Assertions have been autogenerated by utils/update_test_checks.py
; RUN: opt -S -passes=memcpyopt < %s | FileCheck %s

define void @test_copy_uninit(ptr %arg) {
; CHECK-LABEL: @test_copy_uninit(
; CHECK-NEXT:  start:
; CHECK-NEXT:    [[ALLOCA:%.*]] = alloca [1000 x i32], align 4
; CHECK-NEXT:    [[END:%.*]] = getelementptr inbounds [1000 x [1000 x i32]], ptr [[ARG:%.*]], i64 0, i64 1000
; CHECK-NEXT:    br label [[LOOP:%.*]]
; CHECK:       loop:
; CHECK-NEXT:    [[CURRENT:%.*]] = phi ptr [ [[ARG]], [[START:%.*]] ], [ [[NEXT:%.*]], [[LOOP]] ]
; CHECK-NEXT:    [[NEXT]] = getelementptr inbounds [1000 x i32], ptr [[CURRENT]], i64 1
; CHECK-NEXT:    [[COND:%.*]] = icmp eq ptr [[NEXT]], [[END]]
; CHECK-NEXT:    br i1 [[COND]], label [[EXIT:%.*]], label [[LOOP]]
; CHECK:       exit:
; CHECK-NEXT:    ret void
;
start:
  %alloca = alloca [1000 x i32], align 4
  %end = getelementptr inbounds [1000 x [1000 x i32]], ptr %arg, i64 0, i64 1000
  br label %loop

loop:                                             ; preds = %loop, %start
  %current = phi ptr [ %arg, %start ], [ %next, %loop ]
  call void @llvm.memcpy.p0.p0.i64(ptr nonnull align 4 dereferenceable(4000) %current, ptr nonnull align 4 dereferenceable(4000) %alloca, i64 4000, i1 false)
  %next = getelementptr inbounds [1000 x i32], ptr %current, i64 1
  %cond = icmp eq ptr %next, %end
  br i1 %cond, label %exit, label %loop

exit:                                             ; preds = %loop
  ret void
}

define void @test_copy_zero(ptr %arg) {
; CHECK-LABEL: @test_copy_zero(
; CHECK-NEXT:  start:
; CHECK-NEXT:    [[ALLOCA:%.*]] = alloca [1000 x i32], align 4
; CHECK-NEXT:    call void @llvm.memset.p0.i64(ptr nonnull align 4 dereferenceable(4000) [[ALLOCA]], i8 0, i64 4000, i1 false)
; CHECK-NEXT:    [[END:%.*]] = getelementptr inbounds [1000 x [1000 x i32]], ptr [[ARG:%.*]], i64 0, i64 1000
; CHECK-NEXT:    br label [[LOOP:%.*]]
; CHECK:       loop:
; CHECK-NEXT:    [[CURRENT:%.*]] = phi ptr [ [[ARG]], [[START:%.*]] ], [ [[NEXT:%.*]], [[LOOP]] ]
; CHECK-NEXT:    call void @llvm.memset.p0.i64(ptr align 4 [[CURRENT]], i8 0, i64 4000, i1 false)
; CHECK-NEXT:    [[NEXT]] = getelementptr inbounds [1000 x i32], ptr [[CURRENT]], i64 1
; CHECK-NEXT:    [[COND:%.*]] = icmp eq ptr [[NEXT]], [[END]]
; CHECK-NEXT:    br i1 [[COND]], label [[EXIT:%.*]], label [[LOOP]]
; CHECK:       exit:
; CHECK-NEXT:    ret void
;
start:
  %alloca = alloca [1000 x i32], align 4
  call void @llvm.memset.p0.i64(ptr nonnull align 4 dereferenceable(4000) %alloca, i8 0, i64 4000, i1 false)
  %end = getelementptr inbounds [1000 x [1000 x i32]], ptr %arg, i64 0, i64 1000
  br label %loop

loop:                                             ; preds = %loop, %start
  %current = phi ptr [ %arg, %start ], [ %next, %loop ]
  call void @llvm.memcpy.p0.p0.i64(ptr nonnull align 4 dereferenceable(4000) %current, ptr nonnull align 4 dereferenceable(4000) %alloca, i64 4000, i1 false)
  %next = getelementptr inbounds [1000 x i32], ptr %current, i64 1
  %cond = icmp eq ptr %next, %end
  br i1 %cond, label %exit, label %loop

exit:                                             ; preds = %loop
  ret void
}

declare void @llvm.memset.p0.i64(ptr nocapture writeonly, i8, i64, i1 immarg)
declare void @llvm.memcpy.p0.p0.i64(ptr noalias nocapture writeonly, ptr noalias nocapture readonly, i64, i1 immarg)
